;;; - ------------------------------------------------------------------------------ - ;
;;; -                A C M - T O L E R A N Z I N F O                                 - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung : Erstellung einer Passungsliste aus den Bemassungen der DWG      - ;
;;; - Befehle      : TOLERANZINFO                                                    - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 15.02.2023                                                - ;
;;; -              durch : Thomas Krger                                             - ;
;;; - ------------------------------------------------------------------------------ - ;
(vl-load-com)
;;; - ------------------------------------------------------------------------------ - ;
(defun C:TOLERANZINFO( / F0 F1 OLDCMD OLDATT NR
                         TOLERANZCALC MAKE:TLIST0 MAKE:TLIST1 TOLERANZ GETTOLERANZLIST
                     )
  
  (defun TOLERANZCALC( M TF Q                                
                     / I D1 D2 IINDEX LINDEX L1 L2 OG UG OG_T UG_T M_T
                       OLDDIMZIN
                     )  
    (if(and(cond
             ((= Q  0)(setq I  '(0.5 0.6 0.6 0.8 1.0 1.0 1.2 1.5 2.0 3.0 4.0 5.0 6.0)))
             ((= Q  1)(setq I  '(0.8 1.0 1.0 1.2 1.5 1.5 2.0 2.5 3.5 4.5 6.0 7.0 8.0)))
             ((= Q  2)(setq I  '(1.2 1.5 1.5 2.0 2.5 2.5 3.0 4.0 5.0 7.0 8.0 9.0  10)))
             ((= Q  3)(setq I  '(2.0 2.5 2.5 3.0 4.0 4.0 5.0 6.0 8.0  10  12  13  18))
                      (setq D1 '(0.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 2.0 2.0 2.0 2.0))
                      (setq D2 '(3.0 3.0 3.0 3.0 3.0 3.0 4.0 4.0 4.0 4.0 5.0 5.0))
             ) 
             ((= Q  4)(setq I  '(3.0 4.0 4.0 5.0 6.0 7.0 8.0  10  12  14  16  18  20))
                      (setq D1 '(0.0 1.5 1.5 2.0 2.0 2.0 2.0 3.0 3.0 3.0 3.0 4.0 4.0))
                      (setq D2 '(4.0 4.0 4.0 4.0 4.0 4.0 4.0 4.0 5.0 5.0 5.0 5.0))
             )
             ((= Q  5)(setq I  '(  4   5   6   8   9  11  13  15  18  20  23  25  27))
                      (setq D1 '(0.0 1.0 2.0 3.0 3.0 3.0 3.0 4.0 4.0 5.0 5.0 5.0 5.0))
                      (setq D2 '(6.0 6.0 6.0 6.0 6.0 6.0 7.0 7.0 7.0 7.0 7.0 7.0))
             ) 
             ((= Q  6)(setq I  '(  6   8   9  11  13  16  19  22  25  29  32  36  40))
                      (setq D1 '(0.0 3.0 3.0 3.0 3.0 4.0 4.0 5.0 5.0 6.0 6.0 7.0 7.0))
                      (setq D2 '(7.0 7.0 7.0 9.0 9.0 9.0 9.0 9.0  11  11  13  13))
             )
             ((= Q  7)(setq I  '( 10  12  15  18  21  25  30  35  40  46  52  57  63))
                      (setq D1 '(0.0 4.0 6.0 7.0 7.0 8.0 8.0 9.0 9.0  11  11  13  13))
                      (setq D2 '( 15  15  15  17  17  17  20  20  21  21  23  23))
             ) 
             ((= Q  8)(setq I  '( 14  18  22  27  33  39  46  54  63  72  81  89  97))
                      (setq D1 '(0.0 6.0 7.0 9.0 9.0  12  12  14  14  16  16  19  19))
                      (setq D2 '( 23  23  23  26  26  26  29  29  32  32  34  34))
             )
             ((= Q  9)(setq I '(  25   30   36   43   52   62   74   87  100  115  130  140  155)))
             ((= Q 10)(setq I '(  40   48   58   70   84  100  120  140  160  185  210  230  250)))
             ((= Q 11)(setq I '(  60   75   90  110  130  160  190  220  250  290  320  360  400)))
             ((= Q 12)(setq I '( 100  120  150  180  210  250  300  350  400  460  520  570  630)))
             ((= Q 13)(setq I '( 140  180  220  270  330  390  460  540  630  720  810  890  970)))
             ((= Q 14)(setq I '( 250  300  360  430  520  620  740  870 1000 1150 1300 1400 1550)))
             ((= Q 15)(setq I '( 400  480  580  700  840 1000 1200 1400 1600 1850 2100 2300 2500)))
             ((= Q 16)(setq I '( 600  750  900 1100 1300 1600 1900 2200 2500 2900 3200 3600 4000)))
             ((= Q 17)(setq I '(1000 1200 1500 1800 2100 2500 3000 3500 4000 4600 5200 5700 6300)))
           )
           (numberp M)          
           (cond
             ((and(<   0 M)(<= M   3))(setq IINDEX  1)(setq LINDEX  1))
             ((and(<   3 M)(<= M   6))(setq IINDEX  2)(setq LINDEX  2))
             ((and(<   6 M)(<= M  10))(setq IINDEX  3)(setq LINDEX  3))
             ((and(<  10 M)(<= M  14))(setq IINDEX  4)(setq LINDEX  4))
             ((and(<  14 M)(<= M  18))(setq IINDEX  4)(setq LINDEX  5))
             ((and(<  18 M)(<= M  24))(setq IINDEX  5)(setq LINDEX  6))
             ((and(<  24 M)(<= M  30))(setq IINDEX  5)(setq LINDEX  7))
             ((and(<  30 M)(<= M  40))(setq IINDEX  6)(setq LINDEX  8))
             ((and(<  40 M)(<= M  50))(setq IINDEX  6)(setq LINDEX  9))
             ((and(<  50 M)(<= M  65))(setq IINDEX  7)(setq LINDEX 10))
             ((and(<  65 M)(<= M  80))(setq IINDEX  7)(setq LINDEX 11))
             ((and(<  80 M)(<= M 100))(setq IINDEX  8)(setq LINDEX 12))
             ((and(< 100 M)(<= M 120))(setq IINDEX  8)(setq LINDEX 13))
             ((and(< 120 M)(<= M 140))(setq IINDEX  9)(setq LINDEX  1))
             ((and(< 140 M)(<= M 160))(setq IINDEX  9)(setq LINDEX  2))
             ((and(< 160 M)(<= M 180))(setq IINDEX  9)(setq LINDEX  3))
             ((and(< 180 M)(<= M 200))(setq IINDEX 10)(setq LINDEX  4))
             ((and(< 200 M)(<= M 225))(setq IINDEX 10)(setq LINDEX  5))
             ((and(< 225 M)(<= M 250))(setq IINDEX 10)(setq LINDEX  6))
             ((and(< 250 M)(<= M 280))(setq IINDEX 11)(setq LINDEX  7))
             ((and(< 280 M)(<= M 315))(setq IINDEX 11)(setq LINDEX  8))
             ((and(< 315 M)(<= M 355))(setq IINDEX 12)(setq LINDEX  9))
             ((and(< 355 M)(<= M 400))(setq IINDEX 12)(setq LINDEX 10))
             ((and(< 400 M)(<= M 450))(setq IINDEX 13)(setq LINDEX 11))
             ((and(< 450 M)(<= M 500))(setq IINDEX 13)(setq LINDEX 12))
           )
           (=(type TF)'STR)
           (cond
             ((= (strcase TF) "A")
                 (setq L1 '(270 270 280 290 290 300 300  310  320  340  360  380 410))
                 (setq L2 '(460 520 580 660 740 820 920 1050 1200 1350 1500 1650    ))
             )
             ((= (strcase TF) "B")
                 (setq L1 '(140 140 150 150 150 160 160 170 180 190 200 220 240))
                 (setq L2 '(260 280 310 340 380 420 480 540 600 680 760 840    ))
             )
             ((= (strcase TF) "C")
                 (setq L1 '( 60  70  80  95  95 110 110 120 130 140 150 170 180))
                 (setq L2 '(200 210 230 240 260 280 300 330 360 400 440 480    ))
             )
             ((= TF "CD") (setq L1 '( 34 46 56)))
             ((= (strcase TF) "D")
                 (setq L1 '( 20  30  40  50  50  65  65  80  80 100 100 120 120))
                 (setq L2 '(145 145 145 170 170 170 190 190 210 210 230 230    ))
             )
             ((= (strcase TF) "E")
                 (setq L1 '( 14  20  25  32  32  40  40  50  50  60  60  72  72))
                 (setq L2 '( 85  85  85 100 100 100 110 110 125 125 135 135    ))
             )
             ((= TF "EF")(setq L1 '( 10 14 18)))
             ((= (strcase TF) "F")
                 (setq L1 '(  6  10  13  16  16  20  20  25  25  30  30  36  36))
                 (setq L2 '( 43  43  43  50  50  50  56  56  62  62  68  68    ))
             )
             ((= TF "FG")(setq L1 '( 4 6 8)))
             ((= (strcase TF) "G")
                 (setq L1 '(  2   4   5   6   6   7   7   9   9  10  10  12  12))
                 (setq L2 '( 14  14  14  15  15  15  17  17  18  18  20  20    ))
             )
             ((= TF "J")
               (cond
                  ((= Q 6)
                     (setq L1 '(  2   5   5   6   6   8   8  10  10  13  13  16  16))
                     (setq L2 '( 18  18  18  22  22  22  25  25  29  29  33  33    ))
                  )
                  ((= Q 7)
                     (setq L1 '(  4   6   8  10  10  12  12  14  14  18  18  22  22))
                     (setq L2 '( 26  26  26  30  30  30  36  36  39  39  43  43    ))
                  )
                  ((= Q 8)
                     (setq L1 '(  6  10  12  15  15  20  20  24  24  28  28  34  34))
                     (setq L2 '( 41  41  41  47  47  47  55  55  60  60  66  66    ))
                  )
               )   
             )
             ((= TF "j")
               (cond
                  ((= Q 6)
                     (setq L1 '( -2  -2  -2  -3  -3  -4  -4  -5  -5  -7  -7  -9  -9))
                     (setq L2 '(-11 -11 -11 -13 -13 -13 -16 -16 -18 -18 -20 -20    ))
                  )
                  ((= Q 7)
                     (setq L1 '( -4  -4  -5  -6  -6  -8  -8 -10 -10 -12 -12 -15 -15))
                     (setq L2 '(-18 -18 -18 -21 -21 -21 -26 -26 -28 -28 -32 -32    ))
                  )
                  ((= Q 8)
                     (setq L1 '( -6))                   
                  )
               )   
             )
             ((= TF "K")
               (setq L1 (mapcar'(lambda(X)(+ D1 X))'( -2 -1 -1 -1 -1 -2 -2 -2 -2 -2 -2 -3 -3)))
               (setq L2 (mapcar'(lambda(X)(+ D2 X))'( -3 -3 -3 -4 -4 -4 -4 -4 -4 -4 -5 -5   )))
             )
             ((= TF "k")
               (cond
                  ((member Q '( 3 8))
                     (setq L1 '( 0   0   0   0   0   0   0   0   0   0   0   0   0))
                     (setq L2 '( 0   0   0   0   0   0   0   0   0   0   0   0    ))
                  )
                  ('T
                     (setq L1 '( 0   1   1   1   1   2   2   2   2   2   2   3   3))
                     (setq L2 '( 3   3   3   4   4   4   4   4   4   4   5   5    ))
                  )   
               )   
             )
             ((= TF "M")
               (cond
                  ((= Q 8)
                     (setq L1 (mapcar'(lambda(X)(+ D1 X))'(  -2  -4  -6  -7  -7  -8  -8  -9  -9 -11 -11 -13 -13)))
                     (setq L2 (mapcar'(lambda(X)(+ D2 X))'( -15 -15 -15 -17 -17 -17 -20 -20 -21 -21 -23 -23    )))
                  )
                  ('T
                     (setq L1 '( -2  -4  -6  -7  -7  -8  -8  -9  -9 -11 -11 -13 -13))
                     (setq L2 '(-15 -15 -15 -17 -17 -17 -20 -20 -21 -21 -23 -23    ))
                  )   
               )   
             )
             ((= TF "m")
               (setq L1 '(  2   4   6   7   7   8   8   9   9  11  11  13  13))
               (setq L2 '( 15  15  15  17  17  17  20  20  21  21  23  23    ))
             )
             ((= TF "N")
               (cond
                  ((= Q 8)
                     (setq L1 (mapcar'(lambda(X)(+ D1 X))'( -4  -8 -10 -12 -12 -15 -15 -17 -17 -20 -20 -23 -23)))
                     (setq L2 (mapcar'(lambda(X)(+ D2 X))'(-27 -27 -27 -31 -31 -31 -34 -34 -37 -37 -40 -40    )))
                  )
                  ('T
                     (setq L1 '( -4 0 0 0 0 0 0 0 0 0 0 0 0))
                     (setq L2 '(  0 0 0 0 0 0 0 0 0 0 0 0  ))
                  )   
               )             
             )
             ((= TF "n")
               (setq L1 '(  4   8  10  12  12  15  15  17  17  20  20  23  23))
               (setq L2 '( 27  27  27  31  31  31  34  34  37  37  40  40    ))
             )
             ((=(strcase TF)"P")
               (setq L1 '(  6  12  15  18  18  22  22  26  26  32  32  37  37))
               (setq L2 '( 43  43  43  50  50  50  56  56  62  62  68  68    ))
             )
             ((=(strcase TF)"R")
               (setq L1 '( 10  15  19  23  23  28  28  34  34  41  43  51  54))
               (setq L2 '( 63  65  68  77  80  84  94  98 108 114 126 132    ))
             )
             ((=(strcase TF)"S")
               (setq L1 '( 14  19  23  28  28  35  35  43  43  53  59  71  79))
               (setq L2 '( 92 100 108 122 130 140 158 170 190 208 232 252    ))
             )
             ((=(strcase TF)"T")
               (setq L1 '(  0   0   0   0   0   0  41  48  54  66  75  91 104))
               (setq L2 '(122 134 146 166 180 196 218 240 268 294 330 360    ))
             )
             ((=(strcase TF)"U")
               (setq L1 '( 18  23  28  33  33  41  48  60  70  87 102 124 144))
               (setq L2 '(170 190 210 236 258 284 315 350 390 435 490 540    ))
             )
             ((=(strcase TF)"V")
               (setq L1 '(  0   0   0   0  39  47  55  68  81 102 120 146 172))
               (setq L2 '(202 228 252 284 310 340 385 425 475 530 595 660    ))
             )
             ((=(strcase TF)"X")
               (setq L1 '( 20  28  34  40  45  54  64  80  97 122 146 178 210))
               (setq L2 '(248 280 310 350 385 425 475 525 590 660 740 820    ))
             )
             ((=(strcase TF)"Y")
               (setq L1 '(  0   0   0   0   0  63  75  94 114 144 174  214 254))
               (setq L2 '(300 340 380 425 470 520 580 650 730 820 920 1000    ))
             )
             ((=(strcase TF)"Z")
               (setq L1 '( 26  35  42  50  60  73  88 112 136  172  210  258 310))
               (setq L2 '(365 415 465 520 575 640 710 790 900 1000 1100 1250    ))
             )
             ((=(strcase TF)"ZA")
               (setq L1 '( 32  42  52  64  77  98 118  148  180  226  274  335 400))
               (setq L2 '(470 535 600 670 740 820 920 1000 1150 1300 1450 1600    ))
             )
             ((=(strcase TF)"ZB")
               (setq L1 '( 40  50  67  90 108  136  160  200  242  300  360  445 525))
               (setq L2 '(620 700 780 880 960 1050 1200 1300 1500 1650 1850 2100    ))
             )
             ((=(strcase TF)"ZC")
               (setq L1 '( 60  80   97  130  150  188  218  274  325  405  480  585 690))
               (setq L2 '(800 900 1000 1150 1250 1350 1550 1700 1900 2100 2400 2600    ))
             )
             (member (strcase TF) '("H" "JS"))
           )
           (cond       
             ((member TF '("a" "b" "c" "d" "e" "f" "g"))           
               (setq L1(mapcar '- L1))
               (setq L2(mapcar '- L2))            
             )         
             ((member TF '("P" "R" "S" "T" "U" "V" "X" "Y" "Z" "ZA" "ZB" "ZC"))
               (if (<= Q 7)
                 (progn
                   (setq L1 (mapcar'(lambda(X)(- D1 X))L1))
                   (setq L2 (mapcar'(lambda(X)(- D2 X))L2))
                 )
                 (progn
                   (setq L1 (mapcar '- L1))
                   (setq L2 (mapcar '- L2))
                 )
               )
             )
             ('T)
           )
           (cond
             ((= TF  "H") (setq UG 0)(setq OG   (nth(1- IINDEX)I)))
             ((= TF  "h") (setq OG 0)(setq UG (-(nth(1- IINDEX)I))))
             ((= (strcase TF) "JS") (setq OG (/ (nth(1- IINDEX)I) 2))(setq UG (- OG)))
             ('T
               (if(and(< 0 M)(<= M 120))(setq LAGE L1)(setq LAGE L2))
               (if(<=(nth(1- LINDEX)LAGE) 0)
                 (progn
                   (setq OG (nth(1- LINDEX)LAGE))
                   (setq UG (- OG (nth(1- IINDEX)I)))
                 )
                 (progn
                   (setq UG (nth(1- LINDEX)LAGE))
                   (setq OG (+ UG (nth(1- IINDEX)I)))
                 )
               )  
             )
           )
           (numberp OG)
           (numberp UG)
       )
      (progn
        (setq OLDDIMZIN(getvar "DIMZIN"))
        (setvar "DIMZIN" 8)
        (setq M_T(rtos M 2 2))
        (setq TF_T(strcat TF (itoa Q)))
        (setvar "DIMZIN" 1)
        (cond
          ((= OG 0) (setq OG_T " 0"))
          ((> OG 0) (setq OG_T(strcat "+" (rtos (* OG 0.001) 2 3))))
          ('T (setq OG_T (rtos (* OG 0.001) 2 3)))
        )
        (cond
          ((= UG 0) (setq UG_T " 0"))
          ((> UG 0) (setq UG_T(strcat "+" (rtos (* UG 0.001) 2 3))))
          ('T (setq UG_T (rtos (* UG 0.001) 2 3)))
        )      
        (setq OM_T(rtos (+ M (* OG 0.001)) 2 3))
        (setq UM_T(rtos (+ M (* UG 0.001)) 2 3))
        (setvar "DIMZIN" OLDDIMZIN)
        (list M TF Q (* OG 0.001)(* UG 0.001) M_T TF_T OG_T UG_T OM_T UM_T)        
      )
    )  
  )
  (defun MAKE:TLIST0(/ BK)
    (if(or(setq BK(tblobjname "BLOCK" "TLIST0"))
          (and(or(tblobjname  "STYLE" "TOLERANZ")
                 (entmake (list'(0 . "STYLE")'(100 . "AcDbSymbolTableRecord")
                               '(100 . "AcDbTextStyleTableRecord")'(2 . "TOLERANZ")
                               '(70 . 0)'(40 . 0.0)'(41 . 0.8)'(50 . 0.0)'(71 . 0)
                               '(42 . 2.2)'(3 . "romans.shx")'(4 . "")
                          )     
                 )
              )
              (entmake (list'(0 . "BLOCK")'(2 . "TLIST0")'(70 . 0)'(4 . "")'(10 0.0 0.0 0.0)))
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 0.0 0.0 0.0)'(11 0.0 -5.5 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -36.5 0.0 0.0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -18.0 -5.5 0.0)'(11 -18.0 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -36.5 -5.5 0.0)'(11 -36.5 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 0.0 -5.5 0.0)'(11 -36.5 -5.5 0.0)'(210 0.0 0.0 1.0)
                       )
              )         
              (entmake (list'(0 . "TEXT")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbText")'(10 -35.25 -4.25 0.0)'(40 . 3.0)'(1 . "Pama")
                            '(50 . 0.0)'(41 . 0.8)'(51 . 0.0)'(7 . "TOLERANZ")'(71 . 0)'(72 . 0)
                            '(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)'(100 . "AcDbText")'(73 . 0)
                       )
              )
              (entmake (list'(0 . "TEXT")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbText")'(10 -17.0 -4.25 0.0)'(40 . 3.0)'(1 . "Toleranz")
                            '(50 . 0.0)'(41 . 0.8)'(51 . 0.0)'(7 . "TOLERANZ")'(71 . 0)'(72 . 0)
                            '(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)'(100 . "AcDbText")'(73 . 0)
                       )
              )
              (setq BK (entmake (list '(0 . "endblk"))))
          )
       )
      BK
    )
  )  
  (defun MAKE:TLIST1(/ BK)
    (if(or(setq BK(tblobjname "BLOCK" "TLIST1"))
          (and(or(tblobjname "STYLE" "TOLERANZ")
                 (entmake (list'(0 . "STYLE")'(100 . "AcDbSymbolTableRecord")
                               '(100 . "AcDbTextStyleTableRecord")'(2 . "TOLERANZ")
                               '(70 . 0)'(40 . 0.0)'(41 . 0.8)'(50 . 0.0)'(71 . 0)
                               '(42 . 2.2)'(3 . "romans.shx")'(4 . "")
                          )     
                 )
              )
              (entmake (list'(0 . "BLOCK")'(2 . "TLIST1")'(70 . 2)'(4 . "")'(10 0.0 0.0 0.0)))
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 0.0 0.0 0.0)'(11 0.0 -5.5 0.0)'(210 0.0 0.0 1.0)
                       )
              )            
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -36.5 -5.5 0.0)'(11 -36.5 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -18.0 -5.5 0.0)'(11 -18.0 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -10.125 -5.5 0.0)'(11 -10.125 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "LINE")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")
                            '(100 . "AcDbLine")'(10 -36.5 0.0 0.0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -35.25 -4.4 0.0)'(40 . 2.8)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "MASZ")'(2 . "MASZ")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -21.0967 -4.4 0.0)'(40 . 2.8)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 2)'(11 -18.75 -4.4 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "QUALI")'(2 . "QUALI")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -17.375 -2.5 0.0)'(40 . 1.5)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "OABMASZ")'(2 . "OABMASZ")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -17.375 -4.5 0.0)'(40 . 1.5)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "UABMASZ")'(2 . "UABMASZ")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -8.75 -2.5 0.0)'(40 . 1.5)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "OMASZ")'(2 . "OMASZ")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (entmake (list'(0 . "ATTDEF")'(100 . "AcDbEntity")'(67 . 0)'(8 . "0")'(100 . "AcDbText")
                            '(10 -8.75 -4.5 0.0)'(40 . 1.5)'(1 . "-")'(50 . 0.0)'(41 . 0.8)'(51 . 0.0)
                            '(7 . "TOLERANZ")'(71 . 0)'(72 . 0)'(11 0.0 0.0 0.0)'(210 0.0 0.0 1.0)
                            '(100 . "AcDbAttributeDefinition")'(280 . 0)'(3 . "UMASZ")'(2 . "UMASZ")
                            '(70 . 0)'(73 . 0)'(74 . 0)'(280 . 0)
                       )
              )
              (setq BK (entmake (list '(0 . "endblk"))))
          )
       )
      BK
    )
  )
  (defun GETTOLERANZLIST(/ AWS UNFORMAT DT:GET-BEMTXT-FROM-DIMBLOCK QSPLIT)
    (defun DT:GET-BEMTXT-FROM-DIMBLOCK (DIMOBJ / DIMBLOCKOBJ MTEXT)
      (if(and(=(type DIMOBJ)'ENAME)
             (wcmatch(strcase(cdr(assoc 0 (setq DIMOBJ(entget DIMOBJ))))) "*DIMENSION")
             (setq DIMBLOCKOBJ(tblsearch "BLOCK" (cdr(assoc 2 DIMOBJ))))
             (setq DIMBLOCKOBJ(entget(cdr (assoc -2 DIMBLOCKOBJ))))
         )
        (progn
          (while(not(member(cdr(assoc 0 DIMBLOCKOBJ))'("MTEXT" "SEQUEND")))
            (setq DIMBLOCKOBJ(entget(entnext(cdr(assoc -1 DIMBLOCKOBJ)))))
          )
          (if(eq(cdr(assoc 0 DIMBLOCKOBJ))"MTEXT")(setq MTEXT(cdr(assoc 1 DIMBLOCKOBJ))))
        )
      )   
      MTEXT
    )
    
    (defun UNFORMAT(TXT / TEXTSTR DUMMY)
      (if(=(type TXT)'STR)
        (progn
          (setq TEXTSTR "")
          (while (/= TXT "") 
            (cond 
              ((wcmatch (strcase (setq DUMMY (substr TXT 1 2))) "\\[\\{}]")
                (setq TXT (substr TXT 3) TEXTSTR (strcat TEXTSTR DUMMY))
              )
              ((wcmatch (substr TXT 1 1) "[{}]")(setq TXT (substr TXT 2)))
              ((wcmatch (strcase (substr TXT 1 2)) "\\[LO`~]")(setq TXT (substr TXT 3)))
              ((wcmatch (strcase (substr TXT 1 2)) "\\[ACFHQTW]")
                (setq TXT (substr TXT (+ 2 (vl-string-search ";" TXT))))
              )
              ((wcmatch (strcase (substr TXT 1 2)) "\\P")
                 (if(or(= " " (substr TEXTSTR (strlen TEXTSTR)))(= " " (substr TXT 3 1)))
                   (setq TXT (substr TXT 3))
                    (setq TXT (substr TXT 3) TEXTSTR (strcat TEXTSTR " "))
                 )                   
              )          
              ((wcmatch (strcase (substr TXT 1 2)) "\\S")
                (setq DUMMY   (substr TXT 3 (- (vl-string-search ";" TXT) 2)))
                (setq TEXTSTR (strcat TEXTSTR    (vl-string-translate "#^\\" "/^\\" DUMMY)))
                (setq TXT (substr TXT (+ 4 (strlen DUMMY))))              
              )        
              ('T(setq TEXTSTR (strcat TEXTSTR (substr TXT 1 1)))(setq TXT (substr TXT 2)))
            ) 
          )
        )
      )      
      TEXTSTR
    )

    (defun DT:STR-SUBSTSTR(STRING OLDSTRING NEWSTRING / POS OFFSET LISTE)
      (if(and(=(type STRING) 'STR)(=(type OLDSTRING) 'STR)(=(type NEWSTRING) 'STR))
        (progn       
          (setq POS    (vl-string-search OLDSTRING STRING))
          (setq RETURN "")               
          (setq OFFSET (1+(strlen OLDSTRING)))      
          (while POS
            (setq RETURN (strcat RETURN (substr STRING 1 POS) NEWSTRING )
                  STRING (substr STRING (+ POS OFFSET))
                  POS    (vl-string-search OLDSTRING STRING)
            )
          )
          (setq RETURN (strcat RETURN STRING ))
        )
      )
    )
    (defun QSPLIT(TXT / TL F Q)
      (if(=(type TXT)'STR)
        (progn
          (setq TL(mapcar 'chr(vl-string->list (vl-string-trim " "TXT))))
          (while (and(car TL)(not(distof(car TL))))
            (if(/= (car TL)" ")(setq F(cons(car TL)F)))
            (setq TL(cdr TL))
          )          
          (if(and(< 0 (length  F) 3)(setq F(apply 'strcat (reverse F)))
                 (< 0 (length TL)  )(setq Q(apply 'strcat TL))(< 0 (setq Q(atoi Q)))
             )
            (list F Q)
          )
        )  
      )  
    )
    (defun DT:LIST-REMOVE-DOUBLE (L / RL)
      (if (=(type L) 'LIST)
        (progn
          (foreach E L(if(not(member E RL))(setq RL (cons E RL))))          
          (reverse RL)
        )
      )    
    )
    (if(setq AWS(ssget "_X" (list '(0 . "DIMENSION")(cons 410 (getvar "CTAB")))))
      (progn
        (vl-remove-if
          'null
          (mapcar
            '(lambda(X / TXT MT M Q)
               (if(and(=(type (setq X(cadr X)))'ENAME)
                      (setq TXT(DT:GET-BEMTXT-FROM-DIMBLOCK X))
                      (setq TXT(UNFORMAT TXT))
                      (setq TXT(DT:STR-SUBSTSTR TXT "\\U+2205"""))
                  )          
                 (progn
                   (setq MT(mapcar 'chr(vl-string->list TXT)))
                   (while(and(car MT)(not(distof(car MT))))(setq MT(cdr MT)))
                   (if MT (setq M(atof(apply 'strcat MT))))
                   (while(and(car MT)(or(distof(car MT))(=(car MT)".")))(setq MT(cdr MT)))
                   (if MT (setq Q(apply 'strcat MT)))
                   (if(and(numberp M)(setq Q(QSPLIT Q)))(TOLERANZCALC  M (car Q)(cadr Q)))
                 )
               )                   
             )
             (ssnamex AWS)
          )            
        )  
      )
    )  
  )
  (if(and(setq TOLERANZLIST(vl-remove-if-not
                       '(lambda(X)                        
                          (and(=(type X)'LIST)
                              (numberp (car X))
                              (=(type (nth 5 X))'STR)(=(type (nth  6 X))'STR)
                              (=(type (nth 7 X))'STR)(=(type (nth  8 X))'STR)
                              (=(type (nth 9 X))'STR)(=(type (nth 10 X))'STR)
                          )     
                        )
                        (GETTOLERANZLIST)
                     )
        )
        (setq F0(MAKE:TLIST0))
        (setq F1(MAKE:TLIST1))        
     )
    (progn
      (if(setq AWS(ssget "_X" (list '(0 . "INSERT")'(2 . "TLIST0")(cons 410(getvar"CTAB")))))
        (progn
          (setq PKT(cdr(assoc 10(entget(ssname AWS 0)))))
          (setq NR -1)
          (repeat (sslength AWS)(entdel (ssname AWS (setq NR(1+ NR)))))            
        )
        (setq PKT '(0 0 0))
      )  
      (if(setq AWS(ssget "_X" (list '(0 . "INSERT")'(2 . "TLIST1")(cons 410(getvar"CTAB")))))
        (progn
          (setq NR -1)
          (repeat (sslength AWS)(entdel (ssname AWS (setq NR(1+ NR)))))            
        )
      )    
      (setq TOLERANZLIST(vl-sort (DT:LIST-REMOVE-DOUBLE TOLERANZLIST)
                                 '(lambda(X1 X2)(< (car X1)(car X2)))
                        )
      )
      (setq OLDCMD(getvar "CMDECHO"))
      (setq OLDATT(getvar "ATTREQ"))
      (setq OLDDIA(getvar "ATTREQ"))
      (setvar "CMDECHO" 0)
      (setvar "ATTREQ"  1)
      (setvar "ATTDIA"  0)
      (setq LASTOBJ(entlast))
      (while(entnext LASTOBJ) (setq LASTOBJ(entnext LASTOBJ)))
      (command "_insert" "TLIST0" '(0 0 0) 1 1 0)
      
      (setq NR 0)
      (repeat(length TOLERANZLIST)
        (setq X (nth NR TOLERANZLIST))
        (command "_insert" "TLIST1" (list 0 (*(setq Nr(1+ NR))5.5)0) 1 1 0
                 (nth 5 X)(nth 6 X)(nth 7 X)(nth 8 X)(nth 9 X)(nth 10 X)
        )         
      )
      (setq AWS(ssadd))
      (setq OBJ LASTOBJ)
      (while(setq OBJ (entnext OBJ))(ssadd OBJ AWS))
      (setvar "ATTREQ"  OLDATT)
      (setvar "ATTDIA"  OLDDIA)
      (setvar "CMDECHO" OLDCMD)
      (if (/=(distance PKT '(0 0 0))0 0.0001)
        (command "_move" AWS "" '(0 0 0) PKT)
        (command "_move" AWS "" '(0 0 0) pause)
      )  
    )
  )
  (princ)
)
;;; -------------------------------------------------------------------------------- - ;
(defun ACM-TOLERANZINFO:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nACM-TOLERANZINFO : Erstellen einer Passungsliste"
      "\n================== "
      "\n(C) Thomas Krger 2023 (tk@cad-od.de)"
      "\nBefehlszeilenaufruf :  TOLERANZINFO\n"
      "\n"    
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------ - ;
(ACM-TOLERANZINFO:INFO)
(princ)

;;; - ------------------------------------------------------------------------------ - ;
